from typing import List
from ...libs.functions.get_common_vars import get_common_vars
from ...libs.functions.common_ui_elements import collapsable


def anim_block(prop_name:str, main_col, toggles, anim_props) -> None:

    coll_item = collapsable(
        main_col,
        toggles,
        "forces_" + prop_name + "_anim",
        prop_name.replace("_", " ").title(),
        'KEYINGSET',
        align=True,
    )
    if coll_item:

        col = coll_item.grid_flow(row_major=True, columns=2, even_columns=True, even_rows=False, align=True)
        
        labl = col.row(align=True)
        labl.alignment = 'RIGHT'
        labl.label(text="Start | Duration")

        row = col.row(align=True)
        row.prop(anim_props, prop_name + "_start", text="")
        row.prop(anim_props, prop_name + "_duration", text="")

        
        labl = col.row(align=True)
        strength_inc_dec = getattr(anim_props, prop_name + "_inc_dec")
        
        incdec = col.row(align=True)
        btincdec = incdec.row(align=True)
        btincdec.use_property_split = False
        btincdec.scale_x = 9
        btincdec.prop(anim_props, prop_name + "_inc_dec", text="Increase Decrease", toggle=True)
        incdec.prop(anim_props, prop_name + "_inc_dec", text="", toggle=True, icon='TRIA_DOWN' if strength_inc_dec else 'TRIA_LEFT')

        if strength_inc_dec:
            labl = col.row(align=True)
            labl.alignment = 'RIGHT'
            labl.label(text="Increase | Decrease")
            row = col.row(align=True)
            row.prop(anim_props, prop_name + "_increase", text="")
            row.prop(anim_props, prop_name + "_decrease", text="")
        
        col = coll_item.grid_flow(row_major=True, columns=2, even_columns=True, even_rows=False, align=True)

        labl = col.row(align=True)
        labl.alignment = 'RIGHT'
        labl.label(text="From | To")

        row = col.row(align=True)
        row.prop(anim_props, prop_name + "_from", text="")
        row.prop(anim_props, prop_name + "_to", text="")

        
        coll_item.separator()
        
        bt = coll_item.grid_flow(row_major=True, columns=2, even_columns=True, even_rows=False, align=True)
        bt.scale_y = 1.3
        bt.label(text="")

        is_animed = getattr(anim_props, prop_name + "_animed")

        if not is_animed:
            text="Add"
            icon='KEY_HLT'
        else:
            text="Remove"
            icon='KEY_DEHLT'
            bt.alert = True

        bt.operator("fluidlab.forces_anim_props", text=text, icon=icon).prop_name = prop_name


def get_all_properties_from_all_forces_obs(f_forces, force_ob) -> List:

    fields = {
        'BOID':         ("strength", "flow"),
        'CHARGE':       ("strength", "flow"),
        'GUIDE':        ("guide_free", "falloff_power"),
        'DRAG':         ("linear_drag", "quadratic_drag"),
        'FLUID_FLOW':   ("strength", "flow"),
        'FORCE':        ("strength", "flow"),
        'HARMONIC':     ("strength", "harmonic_damping", "rest_length"),
        'LENNARDJ':     ("strength", "flow"),
        'MAGNET':       ("strength", "flow"),
        'TEXTURE':      ("strength"),
        'TURBULENCE':   ("strength", "size", "flow"),
        'VORTEX':       ("strength", "flow"),
        'WIND':         ("strength", "flow"),
    }
    
    field_type = None

    # Para Emitters
    if f_forces.ff_sections == 'EMITTER':

        psys = force_ob.particle_systems.active
        if psys:
            field_type = psys.settings.force_field_1.type

        
    else: # <- Para Global y Colliders

        if not hasattr(force_ob, "field"):
            return
        
        if force_ob.field is None:
            return
        
        if force_ob.field.type == 'NONE':
            return

        field_type = force_ob.field.type

    if field_type is not None:
        
        all_forces_properties = set()
        for field in fields[field_type]:
            all_forces_properties.add(field)
            
        return list(all_forces_properties)
    

def forces_anim_ui(context, layout, f_forces, force_ob):
    
    if force_ob is not None:
        
        wm = context.window_manager
        wm['anim_force_ob'] = force_ob

        toggles = get_common_vars(context, get_toggles=True)
        
        anim_props = force_ob.fluidlab.force_anim

        all_forces_properties = get_all_properties_from_all_forces_obs(f_forces, force_ob)
        
        if all_forces_properties:

            layout.separator()
            main_col = layout.column(align=True)
            main_col.use_property_split = True

            # Muestro las properties que tengan todos los forces:
            for prop_name in all_forces_properties:
                anim_block(prop_name, main_col, toggles, anim_props)
